function init_audio() {
    _audio.src = 'media/music.ogg';
    _audio.load();
    _audio.preload = true;
    _audio.muted = true;
    _audio.addEventListener('canplay', on_audio_ready)
}

function on_audio_ready() {
    if (!EDITMODE) {
        unmute_audio();
        _audio.play();
    }
    if (!EDITMODE || _audio.paused === true) {
        main_loop();
    }
}

function unmute_audio() {
    _audio.muted = false;
    console.log("[unmute_audio] " + _audio.muted);
}

function on_sync_ready(){
    //jsRocket is done getting all the info you already have in Rocket, or is done parsing the .rocket file

    //this either adds a track to Rocket, or gets it for you
    rocket_beat = _syncDevice.getTrack('beat');
    rocket_phase = _syncDevice.getTrack('phase');
    rocket_flow = _syncDevice.getTrack('flow');

    // Initialize audio
    init_audio();
}

function on_sync_update(newRow){
    //rocket_row is only given if you navigate, or change a value on the row in Rocket
    //on interpolation change (hit [i]) no rocket_row value is sent, as the current there is the upper row of your block
    if(!isNaN(newRow)){
        rocket_row = newRow;
    }
    _audio.currentTime = rocket_row / ROW_RATE;
}

function on_play(){
  //you could also set tune.currentTime here
  console.log("[onPlay] time in seconds", rocket_row / ROW_RATE);
  _audio.currentTime = rocket_row / ROW_RATE;
  _audio.play();
  main_loop();
}

function on_pause(){
  //pause your tune
  console.log("[onPause] time in seconds", rocket_row / ROW_RATE);
  _audio.pause();
}

function update_rocket_vals() {
    rocket_row = _audio.currentTime * ROW_RATE;
    if (_audio.paused === false) {
        _syncDevice.update(rocket_row);
    }
    _rocketvals.beat = rocket_beat.getValue(rocket_row);
    _rocketvals.phase = rocket_phase.getValue(rocket_row);
    _rocketvals.flow = rocket_flow.getValue(rocket_row);
}

function main_loop(t) {
    update_rocket_vals();
    let time = _audio.currentTime;
    _ctx.clearRect(0,0,_canvas.width,_canvas.height);

    if (_rocketvals.phase == 0) {
        scene_controls_logo.phi = _rocketvals.flow;
        scene_logo(time);
    } else if (_rocketvals.phase == 1) {
        scene_controls_logo.phi = _rocketvals.flow;
        scene_controls_web.beat = _rocketvals.beat;
        scene_web(time);
        scene_logo(time);
    } else if (_rocketvals.phase == 2) {
        scene_controls_logo.phi = _rocketvals.flow;
        scene_controls_flight.beat = _rocketvals.beat;
        scene_flight(time);
        scene_logo(time);
    } else if (_rocketvals.phase == 3) {
        scene_plasma(time);
    }

    if (_audio.paused === false)
        window.requestAnimationFrame(main_loop);
}

function main() {
    _ctx.clearRect(0,0,_canvas.width,_canvas.height);

    [scene_flight, scene_controls_flight] = spaceflight(_canvas, _ctx, MID, {timescale: 1.});
    [scene_logo, scene_controls_logo] = demo_logo_anim(_canvas, _ctx, MID, {timescale: .3});
    [scene_plasma, scene_controls_plasma] = plasma(_canvas, _ctx, MID, {timescale: .5});
    [scene_web, scene_controls_web] = web(_canvas, _ctx, MID, {lt: _audio.currentTime});

    if (EDITMODE) {
        _syncDevice.setConfig({socketURL:"ws://localhost:1339/"});
        _syncDevice.init();
    } else {
        _syncDevice.setConfig({rocketXML:"media/track.rocket"});
        _syncDevice.init("demo");
    }

    //-- set up all the things --
    //this is also triggered when the Rocket XML is done, so make sure your ogg is ready
    _syncDevice.on('ready', on_sync_ready);
    _syncDevice.on('update', on_sync_update);
    _syncDevice.on('play', on_play);
    _syncDevice.on('pause', on_pause);
}